DROP TABLE IF EXISTS `tbl_channel`;

CREATE TABLE `tbl_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(50) NOT NULL,
  `channel_type` varchar(100) NOT NULL DEFAULT 'Streaming' COMMENT 'Streaming, Youtube, etc',
  `channel_video_id` varchar(50) DEFAULT NULL COMMENT 'Youtube Video Id',
  `channel_video_id_two` varchar(50) DEFAULT NULL,
  `channel_image` varchar(50) NOT NULL,
  `channel_url` text NOT NULL,
  `channel_url_two` text NOT NULL,
  `channel_user_agent` varchar(255) DEFAULT NULL,
  `channel_description` text NOT NULL,
  `link1_label` varchar(15) NOT NULL DEFAULT 'Link 1',
  `link2_label` varchar(15) NOT NULL DEFAULT 'Link 2',
  `active` char(1) DEFAULT '1' COMMENT '1=Active, 0=Inactive',
  `createdAt` varchar(20) NOT NULL,
  `updatedAt` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

/*Data for the table `tbl_channel` */

insert  into `tbl_channel`(`id`,`channel_name`,`channel_type`,`channel_video_id`,`channel_video_id_two`,`channel_image`,`channel_url`,`channel_url_two`,`channel_user_agent`,`channel_description`,`link1_label`,`link2_label`,`active`,`createdAt`,`updatedAt`) values (1,'Music Live','Streaming','','','6123-2023-12-19.png','https://amg01281-9xmediapvtltd-9xjalwa-samsungin-goszf.amagi.tv/playlist/amg01281-9xmediapvtltd-9xjalwa-samsungin/playlist.m3u8','https://service-stitcher.clusters.pluto.tv/stitch/hls/channel/60afa1508284e60007163c08/master.m3u8?appName=web&appVersion=unknown&clientTime=0&deviceDNT=0&deviceId=35fcc6e0-e986-11eb-a0af-c3b401f46211&deviceMake=Chrome&deviceModel=web&deviceType=web&deviceVersion=unknown&includeExtendedEvents=false&serverSideAds=false&sid=a8b6a6bb-4f8c-438e-a638-d4cfa72ae69a','','<p>Mine Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eget pulvinar dui. Nullam tempor tempus euismod. Maecenas sollicitudin lobortis mi, et scelerisque quam sodales ut. Mauris at purus felis. Suspendisse sagittis scelerisque lectus non malesuada. Nam accumsan congue congue. Curabitur finibus erat eu faucibus dictum. Nulla nec tincidunt nibh. Pellentesque in convallis nisl, quis ullamcorper tellus. Integer ipsum velit, aliquam sed tortor at, interdum consectetur risus. Pellentesque luctus cursus ullamcorper. Vestibulum vitae consequat mauris, et pretium ex. Duis suscipit massa pretium ligula tristique, id euismod velit laoreet. Morbi aliquet libero posuere auctor convallis. Cras ac quam in ligula aliquet mollis. Donec condimentum egestas libero a ultricies.</p>\r\n\r\n<p>Vestibulum a mi eu erat eleifend placerat ut non magna. Nulla imperdiet vestibulum sollicitudin. Praesent vel urna nibh. Suspendisse quis pharetra nunc. Duis ut placerat lectus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin quis lacus non ligula pretium accumsan. Proin faucibus quis nisi quis sollicitudin. Nullam mollis sapien sit amet sem rutrum dictum. Duis bibendum nulla id metus imperdiet molestie. Nullam semper, massa non sagittis molestie, diam erat tincidunt dui, quis gravida urna nisl sed ex.</p>\r\n\r\n<p>Nullam posuere efficitur arcu, sit amet faucibus odio sagittis vel. Nunc et metus ac tellus vulputate pretium lacinia id nulla. Pellentesque ultrices rutrum porttitor. Proin convallis non risus nec rhoncus. Proin non mollis erat. Aliquam et leo eget orci tincidunt aliquet sed eu neque. Maecenas luctus luctus lacus eget varius.</p>\r\n\r\n<p>Suspendisse vestibulum felis a purus aliquet, et lacinia lacus dignissim. Nunc vitae felis libero. Quisque dapibus vel tortor nec viverra. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer metus metus, facilisis vitae accumsan sit amet, tincidunt a leo. Integer rutrum velit quis porta porttitor. Fusce pulvinar eget mi nec tristique. Proin consectetur elit dolor, id mattis lorem pellentesque commodo. In faucibus ligula augue, vitae aliquet ante fringilla vitae. Fusce id felis at metus tristique volutpat. Curabitur in nisl egestas, hendrerit sem et, lacinia lectus.</p>\r\n\r\n<p>Nullam condimentum leo sollicitudin sapien congue, dignissim faucibus turpis luctus. Nullam sit amet mattis tortor. Morbi maximus cursus orci et hendrerit. Nunc pulvinar nisl et congue dapibus. Ut ut odio diam. Morbi felis augue, aliquam et ligula quis, scelerisque auctor turpis. Ut vitae velit neque. Integer convallis metus vitae lectus molestie blandit.</p>\r\n','Demo 1','Demo 2','1','2018-07-09 13:29:25','2023-12-19 12:40:11');

/*Table structure for table `tbl_link_count` */

DROP TABLE IF EXISTS `tbl_link_count`;

CREATE TABLE `tbl_link_count` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel_id` int(11) NOT NULL DEFAULT 1,
  `link1_name` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1=Active, 0',
  `link2_name` tinyint(1) DEFAULT 0 COMMENT '1=Active, 0',
  `channel_type` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=Streaming, 2=Youtube, 3=Dailymotion and others',
  `createdDate` varchar(20) NOT NULL,
  `createdTime` varchar(20) NOT NULL,
  `createdAt` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1341 DEFAULT CHARSET=utf8;

/*Data for the table `tbl_link_count` */

insert  into `tbl_link_count`(`id`,`channel_id`,`link1_name`,`link2_name`,`channel_type`,`createdDate`,`createdTime`,`createdAt`) values (819,1,1,0,1,'2021-11-12','13:12:46','2021-11-12 13:12:46'),(820,1,1,0,1,'2021-11-12','13:14:10','2021-11-12 13:14:10'),(821,1,1,0,1,'2021-11-12','13:15:21','2021-11-12 13:15:21'),(822,1,1,0,1,'2021-11-12','13:15:41','2021-11-12 13:15:41'),(823,1,1,0,1,'2021-11-15','11:31:05','2021-11-15 11:31:05'),(824,1,1,0,1,'2021-11-15','12:04:12','2021-11-15 12:04:12'),(825,1,0,1,1,'2021-11-15','12:06:51','2021-11-15 12:06:51'),(826,1,1,0,1,'2021-11-15','12:06:54','2021-11-15 12:06:54'),(827,1,1,0,1,'2021-11-15','16:27:07','2021-11-15 16:27:07'),(828,1,0,1,1,'2021-11-15','16:27:13','2021-11-15 16:27:13'),(829,1,1,0,1,'2021-11-15','16:27:18','2021-11-15 16:27:18'),(830,1,1,0,1,'2021-11-15','17:11:17','2021-11-15 17:11:17'),(831,1,0,1,1,'2021-11-15','17:11:35','2021-11-15 17:11:35'),(832,1,1,0,1,'2021-11-15','17:12:21','2021-11-15 17:12:21'),(833,1,0,1,1,'2021-11-15','17:12:25','2021-11-15 17:12:25'),(834,1,1,0,1,'2021-11-15','17:14:02','2021-11-15 17:14:02'),(835,1,0,1,1,'2021-11-15','17:14:08','2021-11-15 17:14:08'),(836,1,1,0,1,'2021-11-15','17:14:57','2021-11-15 17:14:57'),(837,1,1,0,1,'2021-11-15','17:16:40','2021-11-15 17:16:40'),(838,1,0,1,1,'2021-11-15','17:16:49','2021-11-15 17:16:49'),(839,1,1,0,1,'2021-11-15','17:18:30','2021-11-15 17:18:30'),(840,1,0,1,1,'2021-11-15','17:18:35','2021-11-15 17:18:35'),(841,1,1,0,1,'2021-11-15','17:19:31','2021-11-15 17:19:31'),(842,1,0,1,1,'2021-11-15','17:19:38','2021-11-15 17:19:38'),(843,1,1,0,1,'2021-11-15','17:22:15','2021-11-15 17:22:15'),(844,1,1,0,1,'2021-11-15','17:23:06','2021-11-15 17:23:06'),(845,1,0,1,1,'2021-11-15','17:23:13','2021-11-15 17:23:13'),(846,1,1,0,1,'2021-11-15','17:23:20','2021-11-15 17:23:20'),(847,1,0,1,1,'2021-11-15','17:23:25','2021-11-15 17:23:25'),(848,1,1,0,1,'2021-11-15','17:23:48','2021-11-15 17:23:48'),(849,1,0,1,1,'2021-11-15','17:23:54','2021-11-15 17:23:54'),(850,1,1,0,1,'2021-11-15','17:24:15','2021-11-15 17:24:15'),(851,1,1,0,1,'2021-11-15','17:55:24','2021-11-15 17:55:24'),(852,1,0,1,1,'2021-11-15','17:55:30','2021-11-15 17:55:30'),(853,1,1,0,1,'2021-11-15','17:56:12','2021-11-15 17:56:12'),(854,1,0,1,1,'2021-11-15','17:56:35','2021-11-15 17:56:35'),(855,1,1,0,1,'2021-11-15','17:58:02','2021-11-15 17:58:02'),(856,1,0,1,1,'2021-11-15','17:58:10','2021-11-15 17:58:10'),(857,1,1,0,1,'2021-11-15','17:58:20','2021-11-15 17:58:20'),(858,1,1,0,1,'2021-11-15','17:59:42','2021-11-15 17:59:42'),(859,1,0,1,1,'2021-11-15','17:59:51','2021-11-15 17:59:51'),(860,1,1,0,1,'2021-11-15','17:59:57','2021-11-15 17:59:57'),(861,1,0,1,1,'2021-11-15','18:00:04','2021-11-15 18:00:04'),(862,1,1,0,1,'2021-11-15','18:01:00','2021-11-15 18:01:00'),(863,1,1,0,1,'2021-11-15','18:02:51','2021-11-15 18:02:51'),(864,1,0,1,1,'2021-11-15','18:03:00','2021-11-15 18:03:00'),(865,1,1,0,1,'2021-11-15','18:04:50','2021-11-15 18:04:50'),(866,1,0,1,1,'2021-11-15','18:04:55','2021-11-15 18:04:55'),(867,1,1,0,1,'2021-11-15','18:05:05','2021-11-15 18:05:05'),(868,1,0,1,1,'2021-11-15','18:05:10','2021-11-15 18:05:10'),(869,1,1,0,1,'2021-11-15','18:06:06','2021-11-15 18:06:06'),(870,1,0,1,1,'2021-11-15','18:06:19','2021-11-15 18:06:19'),(871,1,1,0,1,'2021-11-15','18:07:05','2021-11-15 18:07:05'),(872,1,1,0,1,'2021-11-15','18:07:35','2021-11-15 18:07:35'),(873,1,0,1,1,'2021-11-15','18:07:42','2021-11-15 18:07:42'),(874,1,1,0,1,'2021-11-15','18:08:43','2021-11-15 18:08:43'),(875,1,0,1,1,'2021-11-15','18:08:56','2021-11-15 18:08:56'),(876,1,1,0,1,'2021-11-15','18:10:00','2021-11-15 18:10:00'),(877,1,0,1,1,'2021-11-15','18:10:08','2021-11-15 18:10:08'),(878,1,1,0,1,'2021-11-15','18:11:22','2021-11-15 18:11:22'),(879,1,0,1,1,'2021-11-15','18:11:32','2021-11-15 18:11:32'),(880,1,1,0,1,'2021-11-15','18:12:29','2021-11-15 18:12:29'),(881,1,0,1,1,'2021-11-15','18:12:41','2021-11-15 18:12:41'),(882,1,1,0,1,'2021-11-15','18:13:07','2021-11-15 18:13:07'),(883,1,0,1,1,'2021-11-15','18:13:11','2021-11-15 18:13:11'),(884,1,1,0,1,'2021-11-15','18:14:46','2021-11-15 18:14:46'),(885,1,0,1,1,'2021-11-15','18:14:50','2021-11-15 18:14:50'),(886,1,1,0,1,'2021-11-15','18:15:52','2021-11-15 18:15:52'),(887,1,0,1,1,'2021-11-15','18:16:11','2021-11-15 18:16:11'),(888,1,1,0,1,'2021-11-15','18:16:57','2021-11-15 18:16:57'),(889,1,0,1,1,'2021-11-15','18:17:02','2021-11-15 18:17:02'),(890,1,1,0,1,'2021-11-15','18:30:07','2021-11-15 18:30:07'),(891,1,0,1,1,'2021-11-15','18:30:37','2021-11-15 18:30:37'),(892,1,1,0,1,'2021-11-15','18:36:17','2021-11-15 18:36:17'),(893,1,0,1,1,'2021-11-15','18:36:29','2021-11-15 18:36:29'),(894,1,1,0,1,'2021-11-15','18:37:36','2021-11-15 18:37:36'),(895,1,0,1,1,'2021-11-15','18:37:47','2021-11-15 18:37:47'),(896,1,1,0,1,'2021-11-15','18:38:39','2021-11-15 18:38:39'),(897,1,0,1,1,'2021-11-15','18:38:54','2021-11-15 18:38:54'),(898,1,1,0,1,'2021-11-15','18:39:31','2021-11-15 18:39:31'),(899,1,1,0,1,'2021-11-15','18:40:31','2021-11-15 18:40:31'),(900,1,0,1,1,'2021-11-15','18:40:40','2021-11-15 18:40:40'),(901,1,1,0,1,'2021-11-15','18:42:09','2021-11-15 18:42:09'),(902,1,0,1,1,'2021-11-15','18:42:20','2021-11-15 18:42:20'),(903,1,1,0,1,'2021-11-15','18:42:57','2021-11-15 18:42:57'),(904,1,0,1,1,'2021-11-15','18:43:02','2021-11-15 18:43:02'),(905,1,1,0,1,'2021-11-15','18:43:16','2021-11-15 18:43:16'),(906,1,0,1,1,'2021-11-15','18:43:25','2021-11-15 18:43:25'),(907,1,1,0,1,'2021-11-15','18:43:31','2021-11-15 18:43:31'),(908,1,1,0,1,'2021-11-15','18:44:29','2021-11-15 18:44:29'),(909,1,0,1,1,'2021-11-15','18:45:00','2021-11-15 18:45:00'),(910,1,1,0,1,'2021-11-15','18:45:32','2021-11-15 18:45:32'),(911,1,0,1,1,'2021-11-15','18:45:38','2021-11-15 18:45:38'),(912,1,1,0,1,'2021-11-15','18:45:45','2021-11-15 18:45:45'),(913,1,1,0,1,'2021-11-15','18:46:14','2021-11-15 18:46:14'),(914,1,0,1,1,'2021-11-15','18:46:18','2021-11-15 18:46:18'),(915,1,1,0,1,'2021-11-15','18:46:23','2021-11-15 18:46:23'),(916,1,1,0,1,'2021-11-15','18:46:55','2021-11-15 18:46:55'),(917,1,0,1,1,'2021-11-15','18:47:05','2021-11-15 18:47:05'),(918,1,1,0,1,'2021-11-15','18:47:21','2021-11-15 18:47:21'),(919,1,1,0,1,'2021-11-15','18:48:29','2021-11-15 18:48:29'),(920,1,0,1,1,'2021-11-15','18:48:55','2021-11-15 18:48:55'),(921,1,1,0,1,'2021-11-15','18:49:03','2021-11-15 18:49:03'),(922,1,0,1,1,'2021-11-15','18:49:07','2021-11-15 18:49:07'),(923,1,1,0,1,'2021-11-15','18:52:23','2021-11-15 18:52:23'),(924,1,0,1,1,'2021-11-15','18:52:28','2021-11-15 18:52:28'),(925,1,1,0,1,'2021-11-15','18:52:35','2021-11-15 18:52:35'),(926,1,1,0,1,'2021-11-15','18:55:58','2021-11-15 18:55:58'),(927,1,0,1,1,'2021-11-15','18:56:30','2021-11-15 18:56:30'),(928,1,1,0,1,'2021-11-15','18:57:21','2021-11-15 18:57:21'),(929,1,1,0,1,'2021-11-15','19:21:49','2021-11-15 19:21:49'),(930,1,0,1,1,'2021-11-15','19:21:56','2021-11-15 19:21:56'),(931,1,1,0,1,'2021-11-15','19:22:38','2021-11-15 19:22:38'),(932,1,0,1,1,'2021-11-15','19:22:45','2021-11-15 19:22:45'),(933,1,1,0,1,'2021-11-15','19:22:50','2021-11-15 19:22:50'),(934,1,0,1,1,'2021-11-15','19:22:56','2021-11-15 19:22:56'),(935,1,1,0,1,'2021-11-15','19:25:10','2021-11-15 19:25:10'),(936,1,1,0,1,'2021-11-17','11:25:25','2021-11-17 11:25:25'),(937,1,0,1,1,'2021-11-17','11:25:38','2021-11-17 11:25:38'),(938,1,1,0,1,'2021-11-17','11:30:34','2021-11-17 11:30:34'),(939,1,1,0,1,'2021-11-17','11:33:35','2021-11-17 11:33:35'),(940,1,0,1,1,'2021-11-17','11:36:35','2021-11-17 11:36:35'),(941,1,1,0,1,'2021-11-17','11:38:12','2021-11-17 11:38:12'),(942,1,0,1,1,'2021-11-17','11:38:26','2021-11-17 11:38:26'),(943,1,1,0,2,'2021-11-17','11:41:26','2021-11-17 11:41:26'),(944,1,0,1,2,'2021-11-17','11:42:55','2021-11-17 11:42:55'),(945,1,1,0,2,'2021-11-17','11:49:28','2021-11-17 11:49:28'),(946,1,1,0,2,'2021-11-17','11:50:22','2021-11-17 11:50:22'),(947,1,0,1,2,'2021-11-17','11:50:33','2021-11-17 11:50:33'),(948,1,1,0,2,'2021-11-17','11:50:50','2021-11-17 11:50:50'),(949,1,1,0,2,'2021-11-17','11:54:30','2021-11-17 11:54:30'),(950,1,1,0,2,'2021-11-17','12:21:03','2021-11-17 12:21:03'),(951,1,1,0,2,'2021-11-17','12:21:09','2021-11-17 12:21:09'),(952,1,1,0,2,'2021-11-17','12:24:17','2021-11-17 12:24:17'),(953,1,1,0,2,'2021-11-17','12:24:29','2021-11-17 12:24:29'),(954,1,1,0,2,'2021-11-17','15:12:53','2021-11-17 15:12:53'),(955,1,1,0,2,'2021-11-17','15:12:59','2021-11-17 15:12:59'),(956,1,1,0,2,'2021-11-17','15:13:02','2021-11-17 15:13:02'),(957,1,1,0,2,'2021-11-17','15:13:11','2021-11-17 15:13:11'),(958,1,1,0,2,'2021-11-17','15:16:12','2021-11-17 15:16:12'),(959,1,1,0,2,'2021-11-17','15:16:28','2021-11-17 15:16:28'),(960,1,0,1,2,'2021-11-17','15:16:31','2021-11-17 15:16:31'),(961,1,1,0,2,'2021-11-17','15:16:45','2021-11-17 15:16:45'),(962,1,1,0,2,'2021-11-17','15:24:50','2021-11-17 15:24:50'),(963,1,1,0,3,'2021-11-17','15:30:34','2021-11-17 15:30:34'),(964,1,1,0,3,'2021-11-17','15:30:48','2021-11-17 15:30:48'),(965,1,1,0,3,'2021-11-17','15:30:52','2021-11-17 15:30:52'),(966,1,0,1,3,'2021-11-17','15:30:58','2021-11-17 15:30:58'),(967,1,1,0,3,'2021-11-17','15:31:31','2021-11-17 15:31:31'),(968,1,1,0,3,'2021-11-17','15:34:14','2021-11-17 15:34:14'),(969,1,1,0,3,'2021-11-17','15:53:58','2021-11-17 15:53:58'),(970,1,0,1,3,'2021-11-17','15:54:51','2021-11-17 15:54:51'),(971,1,1,0,3,'2021-11-17','15:57:45','2021-11-17 15:57:45'),(972,1,1,0,3,'2021-11-17','16:02:19','2021-11-17 16:02:19'),(973,1,1,0,3,'2021-11-17','16:03:38','2021-11-17 16:03:38'),(974,1,0,1,3,'2021-11-17','16:03:47','2021-11-17 16:03:47'),(975,1,1,0,2,'2021-11-17','16:04:57','2021-11-17 16:04:57'),(976,1,1,0,2,'2021-11-17','16:21:51','2021-11-17 16:21:51'),(977,1,1,0,2,'2021-11-17','16:22:20','2021-11-17 16:22:20'),(978,1,0,1,2,'2021-11-17','16:22:43','2021-11-17 16:22:43'),(979,1,1,0,1,'2021-11-17','16:23:08','2021-11-17 16:23:08'),(980,1,1,0,1,'2021-11-17','16:23:21','2021-11-17 16:23:21'),(981,1,1,0,2,'2021-11-17','16:30:09','2021-11-17 16:30:09'),(982,1,1,0,1,'2021-11-17','16:30:56','2021-11-17 16:30:56'),(983,1,1,0,1,'2021-11-17','16:38:48','2021-11-17 16:38:48'),(984,1,1,0,2,'2021-11-17','16:42:39','2021-11-17 16:42:39'),(985,1,1,0,2,'2021-11-17','16:42:48','2021-11-17 16:42:48'),(986,1,1,0,2,'2021-11-17','16:42:55','2021-11-17 16:42:55'),(987,1,1,0,2,'2021-11-17','16:44:15','2021-11-17 16:44:15'),(988,1,1,0,2,'2021-11-17','16:44:26','2021-11-17 16:44:26'),(989,1,1,0,2,'2021-11-17','16:44:53','2021-11-17 16:44:53'),(990,1,0,1,2,'2021-11-17','16:44:55','2021-11-17 16:44:55'),(991,1,1,0,2,'2021-11-17','16:44:59','2021-11-17 16:44:59'),(992,1,1,0,2,'2021-11-17','16:46:04','2021-11-17 16:46:04'),(993,1,0,1,2,'2021-11-17','16:46:11','2021-11-17 16:46:11'),(994,1,1,0,2,'2021-11-17','16:46:25','2021-11-17 16:46:25'),(995,1,1,0,2,'2021-11-17','16:46:37','2021-11-17 16:46:37'),(996,1,1,0,2,'2021-11-17','16:46:44','2021-11-17 16:46:44'),(997,1,1,0,2,'2021-11-17','16:46:45','2021-11-17 16:46:45'),(998,1,1,0,2,'2021-11-17','16:47:49','2021-11-17 16:47:49'),(999,1,1,0,2,'2021-11-17','16:48:09','2021-11-17 16:48:09'),(1000,1,1,0,2,'2021-11-17','16:50:45','2021-11-17 16:50:45'),(1001,1,1,0,2,'2021-11-17','16:51:10','2021-11-17 16:51:10'),(1002,1,1,0,1,'2021-11-17','16:51:33','2021-11-17 16:51:33'),(1003,1,1,0,1,'2021-11-17','16:52:38','2021-11-17 16:52:38'),(1004,1,1,0,1,'2021-11-17','16:53:06','2021-11-17 16:53:06'),(1005,1,1,0,2,'2021-11-17','16:54:08','2021-11-17 16:54:08'),(1006,1,1,0,2,'2021-11-17','16:54:28','2021-11-17 16:54:28'),(1007,1,1,0,2,'2021-11-17','16:57:19','2021-11-17 16:57:19'),(1008,1,1,0,2,'2021-11-17','16:59:38','2021-11-17 16:59:38'),(1009,1,1,0,1,'2021-11-17','16:59:55','2021-11-17 16:59:55'),(1010,1,0,1,1,'2021-11-17','17:00:42','2021-11-17 17:00:42'),(1011,1,1,0,2,'2021-11-17','17:00:53','2021-11-17 17:00:53'),(1012,1,0,1,2,'2021-11-17','17:00:59','2021-11-17 17:00:59'),(1013,1,1,0,2,'2021-11-17','17:18:45','2021-11-17 17:18:45'),(1014,1,1,0,1,'2021-11-17','17:18:55','2021-11-17 17:18:55'),(1015,1,1,0,1,'2021-11-17','17:21:14','2021-11-17 17:21:14'),(1016,1,1,0,1,'2021-11-17','17:21:29','2021-11-17 17:21:29'),(1017,1,1,0,1,'2021-11-17','18:00:21','2021-11-17 18:00:21'),(1018,1,0,1,1,'2021-11-17','18:08:09','2021-11-17 18:08:09'),(1019,1,1,0,1,'2021-11-17','18:08:13','2021-11-17 18:08:13'),(1020,1,1,0,1,'2021-11-17','18:09:10','2021-11-17 18:09:10'),(1021,1,1,0,1,'2021-11-17','18:28:03','2021-11-17 18:28:03'),(1022,1,0,1,1,'2021-11-17','18:28:33','2021-11-17 18:28:33'),(1023,1,1,0,1,'2021-11-19','17:16:54','2021-11-19 17:16:54'),(1024,1,1,0,1,'2021-11-19','17:17:09','2021-11-19 17:17:09'),(1025,1,1,0,1,'2021-11-19','17:25:39','2021-11-19 17:25:39'),(1026,1,1,0,1,'2021-11-19','17:25:52','2021-11-19 17:25:52'),(1027,1,1,0,1,'2021-11-19','17:25:57','2021-11-19 17:25:57'),(1028,1,1,0,1,'2021-11-19','17:26:18','2021-11-19 17:26:18'),(1029,1,1,0,1,'2021-11-19','17:27:24','2021-11-19 17:27:24'),(1030,1,1,0,1,'2021-11-19','17:29:03','2021-11-19 17:29:03'),(1031,1,1,0,1,'2021-11-19','17:29:50','2021-11-19 17:29:50'),(1032,1,1,0,1,'2021-11-19','17:30:39','2021-11-19 17:30:39'),(1033,1,1,0,1,'2021-11-19','17:31:37','2021-11-19 17:31:37'),(1034,1,1,0,1,'2021-11-20','13:39:22','2021-11-20 13:39:22'),(1035,1,1,0,1,'2021-11-20','13:40:11','2021-11-20 13:40:11'),(1036,1,1,0,1,'2021-11-20','13:40:28','2021-11-20 13:40:28'),(1037,1,1,0,1,'2021-11-20','13:41:39','2021-11-20 13:41:39'),(1038,1,1,0,1,'2021-11-20','13:43:33','2021-11-20 13:43:33'),(1039,1,1,0,1,'2021-11-22','17:01:26','2021-11-22 17:01:26'),(1040,1,0,1,1,'2021-11-22','17:01:32','2021-11-22 17:01:32'),(1041,1,1,0,1,'2021-11-22','17:01:43','2021-11-22 17:01:43'),(1042,1,1,0,1,'2021-11-24','15:43:54','2021-11-24 15:43:54'),(1043,1,1,0,1,'2021-11-24','15:44:41','2021-11-24 15:44:41'),(1044,1,1,0,1,'2021-11-24','15:45:40','2021-11-24 15:45:40'),(1045,1,1,0,1,'2021-11-24','15:51:33','2021-11-24 15:51:33'),(1046,1,0,1,1,'2021-11-24','15:51:43','2021-11-24 15:51:43'),(1047,1,1,0,1,'2021-11-24','16:12:05','2021-11-24 16:12:05'),(1048,1,1,0,1,'2021-11-24','16:12:46','2021-11-24 16:12:46'),(1049,1,1,0,1,'2022-02-17','11:17:19','2022-02-17 11:17:19'),(1050,1,1,0,1,'2022-02-17','11:19:34','2022-02-17 11:19:34'),(1051,1,1,0,1,'2022-02-17','11:21:09','2022-02-17 11:21:09'),(1052,1,1,0,1,'2022-02-17','11:22:49','2022-02-17 11:22:49'),(1053,1,1,0,1,'2022-02-17','11:23:04','2022-02-17 11:23:04'),(1054,1,1,0,1,'2022-02-17','11:23:30','2022-02-17 11:23:30'),(1055,1,1,0,1,'2022-02-17','11:25:06','2022-02-17 11:25:06'),(1056,1,1,0,1,'2022-02-17','11:25:38','2022-02-17 11:25:38'),(1057,1,1,0,1,'2022-02-17','11:26:16','2022-02-17 11:26:16'),(1058,1,0,1,1,'2022-02-17','11:26:21','2022-02-17 11:26:21'),(1059,1,1,0,1,'2022-02-17','11:26:59','2022-02-17 11:26:59'),(1060,1,0,1,1,'2022-02-17','11:27:11','2022-02-17 11:27:11'),(1061,1,1,0,1,'2022-02-17','11:27:23','2022-02-17 11:27:23'),(1062,1,1,0,1,'2022-02-17','11:27:54','2022-02-17 11:27:54'),(1063,1,0,1,1,'2022-02-17','11:28:05','2022-02-17 11:28:05'),(1064,1,1,0,1,'2022-02-17','11:28:33','2022-02-17 11:28:33'),(1065,1,0,1,1,'2022-02-17','11:28:36','2022-02-17 11:28:36'),(1066,1,1,0,1,'2022-02-17','11:28:55','2022-02-17 11:28:55'),(1067,1,0,1,1,'2022-02-17','11:29:15','2022-02-17 11:29:15'),(1068,1,1,0,1,'2022-02-17','11:32:40','2022-02-17 11:32:40'),(1069,1,1,0,1,'2022-02-17','11:34:31','2022-02-17 11:34:31'),(1070,1,1,0,1,'2022-02-17','11:35:01','2022-02-17 11:35:01'),(1071,1,1,0,1,'2022-02-17','11:39:21','2022-02-17 11:39:21'),(1072,1,1,0,1,'2022-02-17','11:46:11','2022-02-17 11:46:11'),(1073,1,1,0,1,'2022-02-17','11:50:32','2022-02-17 11:50:32'),(1074,1,1,0,1,'2022-02-17','11:52:56','2022-02-17 11:52:56'),(1075,1,1,0,1,'2022-02-17','11:53:20','2022-02-17 11:53:20'),(1076,1,1,0,1,'2022-02-17','11:54:12','2022-02-17 11:54:12'),(1077,1,1,0,1,'2022-02-17','11:55:06','2022-02-17 11:55:06'),(1078,1,1,0,1,'2022-02-17','11:56:58','2022-02-17 11:56:58'),(1079,1,1,0,1,'2022-02-17','11:58:12','2022-02-17 11:58:12'),(1080,1,1,0,1,'2022-02-17','12:00:46','2022-02-17 12:00:46'),(1081,1,1,0,1,'2022-02-17','12:10:04','2022-02-17 12:10:04'),(1082,1,1,0,1,'2022-02-17','12:12:27','2022-02-17 12:12:27'),(1083,1,1,0,1,'2022-02-17','12:12:45','2022-02-17 12:12:45'),(1084,1,1,0,1,'2022-02-17','12:17:37','2022-02-17 12:17:37'),(1085,1,1,0,1,'2022-02-17','12:22:59','2022-02-17 12:22:59'),(1086,1,1,0,1,'2022-02-17','12:24:09','2022-02-17 12:24:09'),(1087,1,1,0,1,'2022-02-18','17:25:08','2022-02-18 17:25:08'),(1088,1,1,0,1,'2022-02-18','17:31:49','2022-02-18 17:31:49'),(1089,1,1,0,1,'2022-02-18','17:34:13','2022-02-18 17:34:13'),(1090,1,0,1,1,'2022-02-18','17:35:08','2022-02-18 17:35:08'),(1091,1,1,0,1,'2022-02-18','17:49:09','2022-02-18 17:49:09'),(1092,1,1,0,1,'2022-02-18','17:49:38','2022-02-18 17:49:38'),(1093,1,1,0,1,'2022-02-18','18:10:28','2022-02-18 18:10:28'),(1094,1,1,0,1,'2022-02-18','18:17:02','2022-02-18 18:17:02'),(1095,1,1,0,1,'2022-02-18','18:19:26','2022-02-18 18:19:26'),(1096,1,0,1,1,'2022-02-18','18:19:48','2022-02-18 18:19:48'),(1097,1,1,0,1,'2022-02-18','18:21:11','2022-02-18 18:21:11'),(1098,1,1,0,1,'2022-02-18','18:24:27','2022-02-18 18:24:27'),(1099,1,1,0,1,'2022-02-18','18:24:47','2022-02-18 18:24:47'),(1100,1,1,0,1,'2022-02-18','18:25:08','2022-02-18 18:25:08'),(1101,1,0,1,1,'2022-02-18','18:26:14','2022-02-18 18:26:14'),(1102,1,1,0,1,'2022-02-18','18:29:37','2022-02-18 18:29:37'),(1103,1,0,1,1,'2022-02-18','18:29:46','2022-02-18 18:29:46'),(1104,1,1,0,1,'2022-02-18','18:29:53','2022-02-18 18:29:53'),(1105,1,1,0,1,'2022-02-18','18:31:42','2022-02-18 18:31:42'),(1106,1,0,1,1,'2022-02-18','18:31:46','2022-02-18 18:31:46'),(1107,1,1,0,1,'2022-02-18','18:31:50','2022-02-18 18:31:50'),(1108,1,1,0,1,'2022-02-18','18:34:56','2022-02-18 18:34:56'),(1109,1,0,1,1,'2022-02-18','18:35:03','2022-02-18 18:35:03'),(1110,1,1,0,1,'2022-02-18','18:35:52','2022-02-18 18:35:52'),(1111,1,1,0,1,'2022-02-18','18:47:05','2022-02-18 18:47:05'),(1112,1,0,1,1,'2022-02-18','18:47:11','2022-02-18 18:47:11'),(1113,1,1,0,1,'2022-02-18','18:48:20','2022-02-18 18:48:20'),(1114,1,0,1,1,'2022-02-18','18:49:44','2022-02-18 18:49:44'),(1115,1,1,0,1,'2022-02-18','18:50:02','2022-02-18 18:50:02'),(1116,1,1,0,1,'2022-02-18','18:50:53','2022-02-18 18:50:53'),(1117,1,0,1,1,'2022-02-18','18:50:57','2022-02-18 18:50:57'),(1118,1,1,0,1,'2022-02-18','18:51:03','2022-02-18 18:51:03'),(1119,1,1,0,1,'2022-02-18','18:52:02','2022-02-18 18:52:02'),(1120,1,0,1,1,'2022-02-18','18:52:10','2022-02-18 18:52:10'),(1121,1,1,0,1,'2022-02-18','18:52:15','2022-02-18 18:52:15'),(1122,1,0,1,1,'2022-02-18','18:52:19','2022-02-18 18:52:19'),(1123,1,1,0,1,'2022-02-18','18:53:37','2022-02-18 18:53:37'),(1124,1,1,0,1,'2022-02-18','18:56:32','2022-02-18 18:56:32'),(1125,1,0,1,1,'2022-02-18','18:56:59','2022-02-18 18:56:59'),(1126,1,1,0,1,'2022-02-18','18:57:20','2022-02-18 18:57:20'),(1127,1,1,0,1,'2022-02-18','18:58:13','2022-02-18 18:58:13'),(1128,1,0,1,1,'2022-02-18','19:01:55','2022-02-18 19:01:55'),(1129,1,1,0,1,'2022-02-18','19:02:01','2022-02-18 19:02:01'),(1130,1,1,0,1,'2022-02-18','19:02:37','2022-02-18 19:02:37'),(1131,1,1,0,1,'2022-02-18','19:05:22','2022-02-18 19:05:22'),(1132,1,1,0,1,'2022-02-18','19:07:13','2022-02-18 19:07:13'),(1133,1,0,1,1,'2022-02-18','19:07:37','2022-02-18 19:07:37'),(1134,1,1,0,1,'2022-02-19','16:49:59','2022-02-19 16:49:59'),(1135,1,1,0,1,'2022-02-19','16:50:09','2022-02-19 16:50:09'),(1136,1,1,0,1,'2022-02-19','16:51:33','2022-02-19 16:51:33'),(1137,1,1,0,1,'2022-02-19','16:52:48','2022-02-19 16:52:48'),(1138,1,0,1,1,'2022-02-19','16:55:27','2022-02-19 16:55:27'),(1139,1,1,0,1,'2022-02-19','17:00:44','2022-02-19 17:00:44'),(1140,1,1,0,1,'2022-02-19','17:07:41','2022-02-19 17:07:41'),(1141,1,0,1,1,'2022-02-19','17:10:34','2022-02-19 17:10:34'),(1142,1,1,0,1,'2022-02-19','17:40:41','2022-02-19 17:40:41'),(1143,1,1,0,1,'2022-02-19','17:42:41','2022-02-19 17:42:41'),(1144,1,1,0,1,'2022-02-19','17:44:27','2022-02-19 17:44:27'),(1145,1,1,0,1,'2022-02-19','17:45:25','2022-02-19 17:45:25'),(1146,1,1,0,1,'2022-02-19','17:46:14','2022-02-19 17:46:14'),(1147,1,1,0,1,'2022-02-19','17:46:37','2022-02-19 17:46:37'),(1148,1,1,0,1,'2022-02-21','11:14:39','2022-02-21 11:14:39'),(1149,1,0,1,1,'2022-02-21','11:15:43','2022-02-21 11:15:43'),(1150,1,1,0,1,'2022-02-21','12:24:54','2022-02-21 12:24:54'),(1151,1,1,0,1,'2022-02-21','12:28:15','2022-02-21 12:28:15'),(1152,1,1,0,1,'2022-02-21','12:30:12','2022-02-21 12:30:12'),(1153,1,1,0,1,'2022-02-21','12:33:04','2022-02-21 12:33:04'),(1154,1,1,0,1,'2022-02-21','12:35:17','2022-02-21 12:35:17'),(1155,1,1,0,1,'2022-02-21','12:49:11','2022-02-21 12:49:11'),(1156,1,1,0,1,'2022-02-23','12:57:34','2022-02-23 12:57:34'),(1157,1,1,0,1,'2022-02-23','12:57:44','2022-02-23 12:57:44'),(1158,1,1,0,1,'2022-02-24','18:10:29','2022-02-24 18:10:29'),(1159,1,1,0,1,'2022-03-09','16:32:18','2022-03-09 16:32:18'),(1160,1,1,0,1,'2022-03-09','16:33:53','2022-03-09 16:33:53'),(1161,1,1,0,1,'2022-03-09','16:36:47','2022-03-09 16:36:47'),(1162,1,0,1,1,'2022-03-09','16:37:32','2022-03-09 16:37:32'),(1163,1,1,0,2,'2022-03-09','17:36:36','2022-03-09 17:36:36'),(1164,1,1,0,2,'2022-03-09','17:46:49','2022-03-09 17:46:49'),(1165,1,0,1,2,'2022-03-09','17:52:59','2022-03-09 17:52:59'),(1166,1,1,0,1,'2022-03-09','17:53:51','2022-03-09 17:53:51'),(1167,1,1,0,1,'2022-03-09','17:54:14','2022-03-09 17:54:14'),(1168,1,0,1,1,'2022-03-09','17:54:17','2022-03-09 17:54:17'),(1169,1,1,0,1,'2022-03-09','17:55:18','2022-03-09 17:55:18'),(1170,1,1,0,1,'2022-03-09','17:56:13','2022-03-09 17:56:13'),(1171,1,0,1,1,'2022-03-09','17:56:19','2022-03-09 17:56:19'),(1172,1,1,0,1,'2022-03-09','17:56:24','2022-03-09 17:56:24'),(1173,1,0,1,1,'2022-03-09','17:58:40','2022-03-09 17:58:40'),(1174,1,1,0,1,'2022-03-09','18:02:38','2022-03-09 18:02:38'),(1175,1,0,1,1,'2022-03-09','18:02:50','2022-03-09 18:02:50'),(1176,1,1,0,1,'2022-03-09','18:03:07','2022-03-09 18:03:07'),(1177,1,0,1,1,'2022-03-09','18:05:16','2022-03-09 18:05:16'),(1178,1,1,0,1,'2022-03-09','18:11:09','2022-03-09 18:11:09'),(1179,1,1,0,1,'2022-03-09','18:11:46','2022-03-09 18:11:46'),(1180,1,1,0,1,'2022-03-09','18:16:57','2022-03-09 18:16:57'),(1181,1,0,1,1,'2022-03-09','18:17:23','2022-03-09 18:17:23'),(1182,1,1,0,1,'2022-03-09','18:17:28','2022-03-09 18:17:28'),(1183,1,1,0,1,'2022-03-09','18:21:47','2022-03-09 18:21:47'),(1184,1,1,0,1,'2022-03-09','18:25:08','2022-03-09 18:25:08'),(1185,1,1,0,1,'2022-03-09','18:27:46','2022-03-09 18:27:46'),(1186,1,1,0,1,'2022-03-09','18:30:01','2022-03-09 18:30:01'),(1187,1,0,1,1,'2022-03-09','18:32:01','2022-03-09 18:32:01'),(1188,1,1,0,1,'2022-03-09','18:32:15','2022-03-09 18:32:15'),(1189,1,1,0,1,'2022-03-09','18:39:09','2022-03-09 18:39:09'),(1190,1,0,1,1,'2022-03-09','18:39:32','2022-03-09 18:39:32'),(1191,1,1,0,1,'2022-03-09','18:40:25','2022-03-09 18:40:25'),(1192,1,1,0,1,'2022-03-09','18:45:25','2022-03-09 18:45:25'),(1193,1,1,0,1,'2022-03-09','18:46:03','2022-03-09 18:46:03'),(1194,1,1,0,1,'2022-03-09','18:52:02','2022-03-09 18:52:02'),(1195,1,1,0,1,'2022-03-09','18:52:49','2022-03-09 18:52:49'),(1196,1,1,0,1,'2022-03-09','18:53:56','2022-03-09 18:53:56'),(1197,1,1,0,1,'2022-03-09','18:55:24','2022-03-09 18:55:24'),(1198,1,0,1,1,'2022-03-09','18:55:44','2022-03-09 18:55:44'),(1199,1,1,0,1,'2022-03-09','18:59:20','2022-03-09 18:59:20'),(1200,1,1,0,1,'2022-03-09','19:04:13','2022-03-09 19:04:13'),(1201,1,0,1,1,'2022-03-09','19:04:27','2022-03-09 19:04:27'),(1202,1,1,0,1,'2022-03-09','19:31:23','2022-03-09 19:31:23'),(1203,1,0,1,1,'2022-03-09','19:31:39','2022-03-09 19:31:39'),(1204,1,1,0,1,'2022-03-09','19:31:44','2022-03-09 19:31:44'),(1205,1,1,0,1,'2022-03-09','19:33:04','2022-03-09 19:33:04'),(1206,1,0,1,1,'2022-03-09','19:33:21','2022-03-09 19:33:21'),(1207,1,1,0,1,'2022-03-09','19:35:19','2022-03-09 19:35:19'),(1208,1,1,0,1,'2022-03-09','19:35:43','2022-03-09 19:35:43'),(1209,1,0,1,1,'2022-03-09','19:35:50','2022-03-09 19:35:50'),(1210,1,1,0,1,'2022-03-09','19:35:55','2022-03-09 19:35:55'),(1211,1,1,0,1,'2022-03-09','19:36:04','2022-03-09 19:36:04'),(1212,1,0,1,1,'2022-03-09','19:36:09','2022-03-09 19:36:09'),(1213,1,1,0,1,'2022-03-09','19:36:14','2022-03-09 19:36:14'),(1214,1,1,0,1,'2022-03-10','11:45:36','2022-03-10 11:45:36'),(1215,1,1,0,1,'2022-03-10','11:46:27','2022-03-10 11:46:27'),(1216,1,0,1,1,'2022-03-10','11:46:50','2022-03-10 11:46:50'),(1217,1,0,1,1,'2022-03-10','11:46:58','2022-03-10 11:46:58'),(1218,1,1,0,1,'2022-03-10','11:47:50','2022-03-10 11:47:50'),(1219,1,1,0,1,'2022-03-10','11:47:52','2022-03-10 11:47:52'),(1220,1,1,0,1,'2022-03-10','11:57:44','2022-03-10 11:57:44'),(1221,1,1,0,1,'2022-03-10','15:51:03','2022-03-10 15:51:03'),(1222,1,1,0,1,'2022-03-10','16:53:26','2022-03-10 16:53:26'),(1223,1,0,1,1,'2022-03-10','16:53:34','2022-03-10 16:53:34'),(1224,1,1,0,1,'2022-03-10','16:53:37','2022-03-10 16:53:37'),(1225,1,0,1,1,'2022-03-10','16:53:41','2022-03-10 16:53:41'),(1226,1,1,0,1,'2022-03-10','16:53:44','2022-03-10 16:53:44'),(1227,1,1,0,1,'2022-03-10','16:55:47','2022-03-10 16:55:47'),(1228,1,0,1,1,'2022-03-10','16:55:50','2022-03-10 16:55:50'),(1229,1,1,0,1,'2022-03-10','17:02:54','2022-03-10 17:02:54'),(1230,1,1,0,1,'2022-03-10','17:06:57','2022-03-10 17:06:57'),(1231,1,0,1,1,'2022-03-10','17:07:59','2022-03-10 17:07:59'),(1232,1,1,0,1,'2022-03-10','17:13:15','2022-03-10 17:13:15'),(1233,1,1,0,1,'2022-03-10','17:20:20','2022-03-10 17:20:20'),(1234,1,0,1,1,'2022-03-10','17:22:25','2022-03-10 17:22:25'),(1235,1,1,0,1,'2022-03-10','17:22:50','2022-03-10 17:22:50'),(1236,1,1,0,1,'2022-03-10','17:24:44','2022-03-10 17:24:44'),(1237,1,0,1,1,'2022-03-10','17:24:52','2022-03-10 17:24:52'),(1238,1,1,0,1,'2022-03-10','17:25:45','2022-03-10 17:25:45'),(1239,1,1,0,1,'2022-03-10','17:42:30','2022-03-10 17:42:30'),(1240,1,0,1,1,'2022-03-10','17:44:09','2022-03-10 17:44:09'),(1241,1,1,0,1,'2022-03-10','17:44:21','2022-03-10 17:44:21'),(1242,1,1,0,1,'2022-03-10','17:46:07','2022-03-10 17:46:07'),(1243,1,1,0,1,'2022-03-10','17:58:28','2022-03-10 17:58:28'),(1244,1,1,0,1,'2022-03-10','17:58:58','2022-03-10 17:58:58'),(1245,1,1,0,1,'2022-03-10','18:03:21','2022-03-10 18:03:21'),(1246,1,0,1,1,'2022-03-10','18:04:00','2022-03-10 18:04:00'),(1247,1,1,0,1,'2022-03-10','18:04:08','2022-03-10 18:04:08'),(1248,1,1,0,1,'2022-03-10','19:16:16','2022-03-10 19:16:16'),(1249,1,0,1,1,'2022-03-10','19:31:08','2022-03-10 19:31:08'),(1250,1,1,0,1,'2022-03-10','19:31:18','2022-03-10 19:31:18'),(1251,1,1,0,1,'2022-03-10','19:39:25','2022-03-10 19:39:25'),(1252,1,1,0,1,'2022-03-11','16:51:12','2022-03-11 16:51:12'),(1253,1,0,1,1,'2022-03-11','16:52:02','2022-03-11 16:52:02'),(1254,1,1,0,1,'2022-03-11','16:53:19','2022-03-11 16:53:19'),(1255,1,0,1,1,'2022-03-11','16:54:18','2022-03-11 16:54:18'),(1256,1,1,0,1,'2022-03-11','16:54:25','2022-03-11 16:54:25'),(1257,1,1,0,1,'2022-03-11','16:55:45','2022-03-11 16:55:45'),(1258,1,1,0,3,'2022-05-16','11:59:18','2022-05-16 11:59:18'),(1259,1,1,0,3,'2022-05-16','12:00:10','2022-05-16 12:00:10'),(1260,1,1,0,3,'2022-05-16','15:55:14','2022-05-16 15:55:14'),(1261,1,1,0,3,'2022-05-16','15:56:46','2022-05-16 15:56:46'),(1262,1,0,1,3,'2022-05-16','15:58:52','2022-05-16 15:58:52'),(1263,1,1,0,3,'2022-05-16','16:02:57','2022-05-16 16:02:57'),(1264,1,1,0,3,'2022-05-16','16:05:13','2022-05-16 16:05:13'),(1265,1,1,0,3,'2022-05-16','16:06:58','2022-05-16 16:06:58'),(1266,1,1,0,3,'2022-05-16','16:07:18','2022-05-16 16:07:18'),(1267,1,1,0,3,'2022-05-16','16:09:09','2022-05-16 16:09:09'),(1268,1,1,0,3,'2022-05-16','16:16:58','2022-05-16 16:16:58'),(1269,1,1,0,3,'2022-05-16','16:18:58','2022-05-16 16:18:58'),(1270,1,1,0,3,'2022-05-16','17:38:59','2022-05-16 17:38:59'),(1271,1,1,0,1,'2022-05-23','17:37:42','2022-05-23 17:37:42'),(1272,1,1,0,1,'2022-05-23','17:38:53','2022-05-23 17:38:53'),(1273,1,1,0,1,'2022-05-23','17:43:16','2022-05-23 17:43:16'),(1274,1,1,0,1,'2022-05-23','17:45:49','2022-05-23 17:45:49'),(1275,1,1,0,1,'2022-05-23','17:48:33','2022-05-23 17:48:33'),(1276,1,1,0,1,'2022-05-23','17:50:52','2022-05-23 17:50:52'),(1277,1,0,1,1,'2022-05-23','17:51:32','2022-05-23 17:51:32'),(1278,1,1,0,1,'2022-05-23','17:55:28','2022-05-23 17:55:28'),(1279,1,0,1,1,'2022-05-23','17:55:42','2022-05-23 17:55:42'),(1280,1,1,0,1,'2022-05-23','19:27:33','2022-05-23 19:27:33'),(1281,1,0,1,1,'2022-05-23','19:30:06','2022-05-23 19:30:06'),(1282,1,1,0,1,'2022-06-01','19:03:36','2022-06-01 19:03:36'),(1283,1,1,0,1,'2022-06-01','19:24:53','2022-06-01 19:24:53'),(1284,1,1,0,1,'2022-06-01','19:31:33','2022-06-01 19:31:33'),(1285,1,1,0,1,'2022-06-01','19:42:17','2022-06-01 19:42:17'),(1286,1,1,0,1,'2022-06-01','19:44:26','2022-06-01 19:44:26'),(1287,1,1,0,1,'2022-06-01','19:44:49','2022-06-01 19:44:49'),(1288,1,1,0,1,'2022-06-01','19:46:42','2022-06-01 19:46:42'),(1289,1,1,0,1,'2022-06-01','19:51:09','2022-06-01 19:51:09'),(1290,1,1,0,1,'2022-06-01','19:52:42','2022-06-01 19:52:42'),(1291,1,1,0,1,'2022-06-01','19:53:51','2022-06-01 19:53:51'),(1292,1,1,0,1,'2022-06-01','19:58:30','2022-06-01 19:58:30'),(1293,1,1,0,1,'2022-06-06','16:02:12','2022-06-06 16:02:12'),(1294,1,1,0,1,'2022-06-06','17:19:42','2022-06-06 17:19:42'),(1295,1,1,0,1,'2022-06-06','17:23:59','2022-06-06 17:23:59'),(1296,1,1,0,1,'2022-06-06','17:27:14','2022-06-06 17:27:14'),(1297,1,1,0,1,'2022-06-06','17:28:45','2022-06-06 17:28:45'),(1298,1,1,0,2,'2023-10-25','17:30:34','2023-10-25 17:30:34'),(1299,1,0,1,2,'2023-10-25','17:31:25','2023-10-25 17:31:25'),(1300,1,1,0,1,'2023-10-25','17:32:15','2023-10-25 17:32:15'),(1301,1,0,1,1,'2023-10-25','17:32:21','2023-10-25 17:32:21'),(1302,1,1,0,1,'2023-10-25','17:33:22','2023-10-25 17:33:22'),(1303,1,0,1,1,'2023-10-25','17:33:36','2023-10-25 17:33:36'),(1304,1,1,0,1,'2023-10-25','17:36:12','2023-10-25 17:36:12'),(1305,1,1,0,2,'2023-12-08','11:51:43','2023-12-08 11:51:43'),(1306,1,0,1,2,'2023-12-08','12:10:43','2023-12-08 12:10:43'),(1307,1,1,0,2,'2023-12-08','12:57:00','2023-12-08 12:57:00'),(1308,1,0,1,2,'2023-12-08','12:58:28','2023-12-08 12:58:28'),(1309,1,1,0,2,'2023-12-08','13:01:19','2023-12-08 13:01:19'),(1310,1,1,0,1,'2023-12-08','13:12:32','2023-12-08 13:12:32'),(1311,1,1,0,2,'2023-12-08','13:15:22','2023-12-08 13:15:22'),(1312,1,1,0,2,'2023-12-08','13:16:06','2023-12-08 13:16:06'),(1313,1,1,0,2,'2023-12-08','13:26:45','2023-12-08 13:26:45'),(1314,1,1,0,2,'2023-12-08','13:29:04','2023-12-08 13:29:04'),(1315,1,1,0,2,'2023-12-08','13:30:51','2023-12-08 13:30:51'),(1316,1,1,0,2,'2023-12-08','13:38:45','2023-12-08 13:38:45'),(1317,1,1,0,2,'2023-12-08','13:40:34','2023-12-08 13:40:34'),(1318,1,1,0,2,'2023-12-08','13:43:57','2023-12-08 13:43:57'),(1319,1,0,1,2,'2023-12-08','13:45:27','2023-12-08 13:45:27'),(1320,1,1,0,2,'2023-12-08','13:52:07','2023-12-08 13:52:07'),(1321,1,1,0,2,'2023-12-08','13:54:38','2023-12-08 13:54:38'),(1322,1,1,0,2,'2023-12-08','13:54:46','2023-12-08 13:54:46'),(1323,1,0,1,2,'2023-12-08','14:10:51','2023-12-08 14:10:51'),(1324,1,1,0,2,'2023-12-08','14:10:53','2023-12-08 14:10:53'),(1325,1,1,0,2,'2023-12-08','14:12:35','2023-12-08 14:12:35'),(1326,1,0,1,2,'2023-12-08','14:12:42','2023-12-08 14:12:42'),(1327,1,1,0,2,'2023-12-08','14:23:49','2023-12-08 14:23:49'),(1328,1,1,0,2,'2023-12-08','18:46:36','2023-12-08 18:46:36'),(1329,1,1,0,2,'2023-12-08','18:47:16','2023-12-08 18:47:16'),(1330,1,0,1,2,'2023-12-08','18:47:50','2023-12-08 18:47:50'),(1331,1,1,0,2,'2023-12-08','19:00:59','2023-12-08 19:00:59'),(1332,1,0,1,2,'2023-12-08','19:01:08','2023-12-08 19:01:08'),(1333,1,1,0,2,'2023-12-08','19:01:13','2023-12-08 19:01:13'),(1334,1,1,0,2,'2023-12-08','19:03:30','2023-12-08 19:03:30'),(1335,1,1,0,2,'2023-12-08','19:15:16','2023-12-08 19:15:16'),(1336,1,0,1,2,'2023-12-08','19:15:19','2023-12-08 19:15:19'),(1337,1,1,0,1,'2023-12-11','13:49:40','2023-12-11 13:49:40'),(1338,1,1,0,3,'2023-12-11','14:02:47','2023-12-11 14:02:47'),(1339,1,1,0,2,'2023-12-11','14:03:42','2023-12-11 14:03:42'),(1340,1,0,1,2,'2023-12-11','14:03:49','2023-12-11 14:03:49');

/*Table structure for table `tbl_notification` */

DROP TABLE IF EXISTS `tbl_notification`;

CREATE TABLE `tbl_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `message` text NOT NULL,
  `image` text DEFAULT NULL,
  `createdAt` varchar(20) NOT NULL,
  `updatedAt` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*Data for the table `tbl_notification` */

insert  into `tbl_notification`(`id`,`title`,`message`,`image`,`createdAt`,`updatedAt`) values (1,'Title - 1','Message - 1',NULL,'2018-09-07 10:00:00','2018-09-07 10:00:00'),(2,'Title - 2','Message - 2',NULL,'2018-09-07 10:00:00','2018-09-07 10:00:00'),(3,'Title - 3','Message - 3',NULL,'2018-09-07 10:00:00','2018-09-07 10:00:00'),(4,'Title - 4','Message - 4 can be stored from textarea.','1827-2018-09-08.png','2018-09-07 10:00:00','2018-09-08 16:00:50');

/*Table structure for table `tbl_settings` */

DROP TABLE IF EXISTS `tbl_settings`;

CREATE TABLE `tbl_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_fcm_key` text NOT NULL,
  `api_key` varchar(255) NOT NULL,
  `app_mandatory_login` tinyint(1) NOT NULL DEFAULT 1,
  `app_name` varchar(50) NOT NULL,
  `app_logo` varchar(255) NOT NULL,
  `app_email` varchar(255) NOT NULL,
  `app_version` varchar(50) NOT NULL,
  `app_author` varchar(255) NOT NULL,
  `app_contact` varchar(255) NOT NULL,
  `app_website` varchar(255) NOT NULL,
  `app_developed_by` varchar(255) NOT NULL,
  `app_description` text NOT NULL,
  `app_privacy_policy` text NOT NULL,
  `publisher_id` varchar(255) NOT NULL,
  `interstital_ad` tinyint(1) NOT NULL DEFAULT 0,
  `interstital_ad_id` varchar(255) NOT NULL,
  `interstital_ad_click` varchar(255) NOT NULL,
  `banner_ad` tinyint(1) NOT NULL DEFAULT 0,
  `banner_ad_id` varchar(255) NOT NULL,
  `force_version_code` int(11) NOT NULL DEFAULT 1 COMMENT 'Must match with Android latest source code versionCode',
  `force_update` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Force Update or Optional Update',
  `force_title` varchar(50) NOT NULL DEFAULT 'New Version Available!',
  `force_message` text NOT NULL COMMENT 'Please download the latest version to continue using the app and get new features.',
  `force_yes_button` varchar(30) NOT NULL DEFAULT 'Update',
  `force_no_button` varchar(30) NOT NULL DEFAULT 'Exit' COMMENT 'if force_update YES, ''Exit'' otherwise ''Continue''',
  `force_source` varchar(100) NOT NULL DEFAULT 'Playstore' COMMENT 'Playstore / Server APK URL',
  `force_apk_link` varchar(255) DEFAULT NULL COMMENT 'Full APK path if Server URL selected',
  `youtube_dev_api` varchar(255) NOT NULL COMMENT 'You can follow this link : https://developers.google.com/youtube/android/player/register',
  `app_direction` varchar(3) NOT NULL DEFAULT 'rtl' COMMENT 'rtl or ltr',
  `createdAt` varchar(50) NOT NULL,
  `updatedAt` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

/*Data for the table `tbl_settings` */

insert  into `tbl_settings`(`id`,`app_fcm_key`,`api_key`,`app_mandatory_login`,`app_name`,`app_logo`,`app_email`,`app_version`,`app_author`,`app_contact`,`app_website`,`app_developed_by`,`app_description`,`app_privacy_policy`,`publisher_id`,`interstital_ad`,`interstital_ad_id`,`interstital_ad_click`,`banner_ad`,`banner_ad_id`,`force_version_code`,`force_update`,`force_title`,`force_message`,`force_yes_button`,`force_no_button`,`force_source`,`force_apk_link`,`youtube_dev_api`,`app_direction`,`createdAt`,`updatedAt`) values (1,'AAAA5JtfmjI:APA91bGSesJla8hR381f90SrcLBaA84RxnTT8AkhUDNaW0h1Sqed7x7IDRIikzHJazrizpe65RH-SwjczXGm8KTIsB3zU-QnWJzLh_ApC_GgMqymD8vzv0wCo9O2p1cXxYmaiSfXuYZD','bbkbrLoJcPeC6XuAinWfpGHNEqRMVIODmY9Uwyh07sla28B',0,'My Single Live TV','1224-2021-09-07.png','info@bytesbee.com','1.1','Prashant Adesara','+91 82002 54187','https://bytesbee.com','BytesBee','<p>This Application is the best application for Streaming videos, User can play their favorite videos through applications.</p>\r\n\r\n<ul>\r\n	<li><span dir=\"ltr\">Easy to stream video</span></li>\r\n	<li><span dir=\"ltr\">YouTube Video Supported</span></li>\r\n	<li><span dir=\"ltr\">Embedded video supported (DailyMotion, Open Load, Vimeo, Very Stream)</span></li>\r\n	<li><span dir=\"ltr\">Great Materialize Design</span></li>\r\n	<li><span dir=\"ltr\">Push Notification handling</span></li>\r\n	<li><span dir=\"ltr\">User Friendly</span></li>\r\n</ul>\r\n\r\n<p><span dir=\"ltr\">My Single Live TV Application is designed and developed by BytesBee(INDIA), for more Applications contact info@bytesbee.com</span></p>\r\n\r\n<p><span dir=\"ltr\">Website: www.bytesbee.com</span></p>\r\n\r\n<p><span dir=\"ltr\">We also develop custom applications, if you need any kind of custom application contact us on the given Email or Contact No.</span></p>\r\n\r\n<p><span dir=\"ltr\"><strong>Email:</strong> info@bytesbee.com</span><br />\r\n<span dir=\"ltr\"><strong>WhatsApp:</strong> +91 82002 54187</span><br />\r\n<span dir=\"ltr\"><strong>Website:</strong>&nbsp;https://www.bytesbee.com</span></p>\r\n','<p>Effective date: Sept 15, 2021</p>\r\n\r\n<p>BytesBee (&quot;us&quot;, &quot;we&quot;, or &quot;our&quot;) operates the http://www.bytesbee.com website and the My Single Live TV mobile application (the &quot;Service&quot;).</p>\r\n\r\n<p>This page informs you of our policies regarding the collection, use, and disclosure of personal data when you use our Service and the choices you have associated with that data.</p>\r\n\r\n<p>We use your data to provide and improve the Service. By using the Service, you agree to the collection and use of information under this policy. Unless otherwise defined in this Privacy Policy, terms used in this Privacy Policy have the same meanings as in our Terms and Conditions.</p>\r\n\r\n<h2>Information Collection And Use</h2>\r\n\r\n<p>We collect several different types of information for various purposes to provide and improve our Service to you.</p>\r\n\r\n<h3>Types of Data Collected</h3>\r\n\r\n<h4>Personal Data</h4>\r\n\r\n<p>While using our Service, we may ask you to provide us with certain personally identifiable information that can be used to contact or identify you (&quot;Personal Data&quot;). Personally, identifiable information may include, but is not limited to:</p>\r\n\r\n<ul>\r\n	<li>Email address</li>\r\n	<li>Cookies and Usage Data</li>\r\n</ul>\r\n\r\n<h4>Usage Data</h4>\r\n\r\n<p>We may also collect information that your browser sends whenever you visit our Service or when you access the Service by or through a mobile device (&quot;Usage Data&quot;).</p>\r\n\r\n<p>This Usage Data may include information such as your computer&#39;s Internet Protocol address (e.g. IP address), browser type, browser version, the pages of our Service that you visit, the time and date of your visit, the time spent on those pages, unique device identifiers and other diagnostic data.</p>\r\n\r\n<p>When you access the Service by or through a mobile device, this Usage Data may include information such as the type of mobile device you use, your mobile device unique ID, the IP address of your mobile device, your mobile operating system, the type of mobile Internet browser you use, unique device identifiers and other diagnostic data.</p>\r\n\r\n<h4>Tracking &amp; Cookies Data</h4>\r\n\r\n<p>We use cookies and similar tracking technologies to track the activity on our Service and hold certain information.</p>\r\n\r\n<p>Cookies are files with a small amount of data which may include an anonymous unique identifier. Cookies are sent to your browser from a website and stored on your device. Tracking technologies also used are beacons, tags, and scripts to collect and track information and to improve and analyze our Service.</p>\r\n\r\n<p>You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent. However, if you do not accept cookies, you may not be able to use some portions of our Service.</p>\r\n\r\n<p>Examples of Cookies we use:</p>\r\n\r\n<ul>\r\n	<li><strong>Session Cookies.</strong> We use Session Cookies to operate our Service.</li>\r\n	<li><strong>Preference Cookies.</strong> We use Preference Cookies to remember your preferences and various settings.</li>\r\n	<li><strong>Security Cookies.</strong> We use Security Cookies for security purposes.</li>\r\n</ul>\r\n\r\n<h2>Use of Data</h2>\r\n\r\n<p>BytesBee uses the collected data for various purposes:</p>\r\n\r\n<ul>\r\n	<li>To provide and maintain the Service</li>\r\n	<li>To notify you about changes to our Service</li>\r\n	<li>To allow you to participate in interactive features of our Service when you choose to do so</li>\r\n	<li>To provide customer care and support</li>\r\n	<li>To provide analysis or valuable information so that we can improve the Service</li>\r\n	<li>To monitor the usage of the Service</li>\r\n	<li>To detect, prevent and address technical issues</li>\r\n</ul>\r\n\r\n<h2>Transfer Of Data</h2>\r\n\r\n<p>Your information, including Personal Data, may be transferred to &mdash; and maintained on &mdash; computers located outside of your state, province, country or other governmental jurisdiction where the data protection laws may differ than those from your jurisdiction.</p>\r\n\r\n<p>If you are located outside India and choose to provide information to us, please note that we transfer the data, including Personal Data, to India and process it there.</p>\r\n\r\n<p>Your consent to this Privacy Policy followed by your submission of such information represents your agreement to that transfer.</p>\r\n\r\n<p>BytesBee will take all steps reasonably necessary to ensure that your data is treated securely and under this Privacy Policy and no transfer of your Personal Data will take place to an organization or a country unless there are adequate controls in place including the security of your data and other personal information.</p>\r\n\r\n<h2>Disclosure Of Data</h2>\r\n\r\n<h3>Legal Requirements</h3>\r\n\r\n<p>BytesBee may disclose your Data in the good faith belief that such action is necessary to:</p>\r\n\r\n<ul>\r\n	<li>To comply with a legal obligation</li>\r\n	<li>To protect and defend the rights or property of BytesBee</li>\r\n	<li>To prevent or investigate possible wrongdoing in connection with the Service</li>\r\n	<li>To protect the personal safety of users of the Service or the public</li>\r\n	<li>To protect against legal liability</li>\r\n</ul>\r\n\r\n<h2>Security Of Data</h2>\r\n\r\n<p>The security of your data is important to us, but remember that no method of transmission over the Internet, or method of electronic storage is 100% secure. While we strive to use commercially acceptable means to protect your Personal Data, we cannot guarantee its absolute security.</p>\r\n\r\n<h2>Service Providers</h2>\r\n\r\n<p>We may employ third party companies and individuals to facilitate our Service (&quot;Service Providers&quot;), to provide the Service on our behalf, to perform Service-related services or to assist us in analyzing how our Service is used.</p>\r\n\r\n<p>These third parties have access to your Personal Data only to perform these tasks on our behalf and are obligated not to disclose or use it for any other purpose.</p>\r\n\r\n<h2>Links To Other Sites</h2>\r\n\r\n<p>Our Service may contain links to other sites that are not operated by us. If you click on a third party link, you will be directed to that third party&#39;s site. We strongly advise you to review the Privacy Policy of every site you visit.</p>\r\n\r\n<p>We have no control over and assume no responsibility for the content, privacy policies, or practices of any third party sites or services.</p>\r\n\r\n<h2>Children&#39;s Privacy</h2>\r\n\r\n<p>Our Service does not address anyone under the age of 18 (&quot;Children&quot;).</p>\r\n\r\n<p>We do not knowingly collect personally identifiable information from anyone under the age of 18. If you are a parent or guardian and you are aware that your Children has provided us with Personal Data, please contact us. If we become aware that we have collected Personal Data from children without verification of parental consent, we take steps to remove that information from our servers.</p>\r\n\r\n<h2>Changes To This Privacy Policy</h2>\r\n\r\n<p>We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page.</p>\r\n\r\n<p>We will let you know via email and/or a prominent notice on our Service, before the change becoming effective and update the &quot;effective date&quot; at the top of this Privacy Policy.</p>\r\n\r\n<p>You are advised to review this Privacy Policy periodically for any changes. Changes to this Privacy Policy are effective when they are posted on this page.</p>\r\n\r\n<h2>Contact Us</h2>\r\n\r\n<p>If you have any questions about this Privacy Policy, please contact us:</p>\r\n\r\n<ul>\r\n	<li>By email: info@bytesbee.com</li>\r\n	<li>By visiting this page on our website: https://bytesbee.com/contact</li>\r\n</ul>\r\n','ca-app-pub-4801125099042575~9621541841',1,'ca-app-pub-4801125099042575/7381415441','0',1,'ca-app-pub-4801125099042575/2098275044',1,1,'New Version Available!','Please download the latest version to continue using the app and get new features.','Update','Exit','Playstore','','AIzaSyBU19ln9W1W85olmtWIUZpGGLlY9JcOroA','LTR','2018-10-20 15:00:00','2022-05-24 07:16:58');

/*Table structure for table `tbl_tokens` */

DROP TABLE IF EXISTS `tbl_tokens`;

CREATE TABLE `tbl_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` text NOT NULL,
  `createdAt` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

/*Data for the table `tbl_tokens` */

insert  into `tbl_tokens`(`id`,`token`,`createdAt`) values (1,'evL45XO1TViroRD5UurGKZ:APA91bG7yrjE8NiYhpNo33Z6K8_CTY_b3La5ZpY_XjIGqOCcoRs8lG3Rd2gZVoumeBg8w5YxTJAR0mxpy3L_e1qoBww2FEyEL_tIv3EwK3XDyBWmlMvYyWXrIjmBlMSux4-XXcqr6ug4','2021-09-17 13:13:32'),(13,'dGdgWt3STGatuDz0vQMeSr:APA91bEjYXtLuEDi4oUOtzVqKfGtadnT4LLumHEdzwWWOMzZAkvK0F9Cz2faDGin0QQfaGIvRjNdjOgC_Y0ltWqfe4KtHzZAOyvbZlYLuAk4dY8umg--cFlxmAQZbxW39b-lVqX9isDD','2022-06-06 17:27:12'),(14,'eR9MZaO28FqETxXPF6wCMl:APA91bGovoDMVI35xnY-NEqqiXAP2yHC8DdpVtLlsfKVXV4EdQOGJEJ17eUoGi2UCSgy5ykl1FvBbS8cXZ7lf_v2Hy05jDL-_awjSsJLYVB87mWrV6IHKNXHUMdxNeQ-aMMUphF4SVmV','2022-07-04 12:16:32'),(15,'f7ydPrdvR1mAzpdBFx31Je:APA91bFx7MJp6frP25kchuE01SMT75iArC8EVl2TeN4-csaEv3LrCvBd9B3cSSTofzXYU9TipxNFd_28E2P23S9QtbpohDtxUHI0tKUJUBkQbv58_Lvu1IsHNhYWLYNxoyo55PDzM2jD','2023-12-08 11:51:43');

/*Table structure for table `tbl_user` */

DROP TABLE IF EXISTS `tbl_user`;

CREATE TABLE `tbl_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(15) NOT NULL,
  `password` text NOT NULL,
  `e_password` text NOT NULL,
  `email` varchar(100) NOT NULL,
  `user_role` enum('100','101','102') NOT NULL,
  `device_type` varchar(20) NOT NULL DEFAULT 'Android',
  `active` char(1) NOT NULL DEFAULT '1' COMMENT '1=Active, 0=Inactive',
  `createdAt` varchar(20) NOT NULL,
  `updatedAt` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

/*Data for the table `tbl_user` */

insert  into `tbl_user`(`id`,`username`,`password`,`e_password`,`email`,`user_role`,`device_type`,`active`,`createdAt`,`updatedAt`) values (1,'admin','d82494f05d6917ba02f7aaa29689ccb444bb73f20380876cb05d1f37537b7892','b6d556d94960d23c581adb1fc2b6a12e0d1d635d2428a19eae1bfae630ae594f','bytesbee@gmail.com','100','Android','1','2021-08-12 08:49:18','2022-03-10 17:02:49'),(2,'prashant','1caa9ac6de001d8f654920a2f8482aa7c035e0ae8019e4383efcbb4937147fca','047d4890ca70059e094a017050b19c0ba9b9cf3ee634bc0c084636b202a3f600','prashant@bytesbee.com','100','Android','1','2021-08-12 08:54:22','2021-09-30 16:16:39'),(3,'user1','b0d98a6ee2e307c8c412a52edde9d63a8f45c7556efb6a8b96c59b2c90ee0c20','85905874453f4e9645e934014e6bc1bd32f4b41953eaea981ec8b821823db9c8','user1@gmail.com','102','Android','0','2021-08-12 08:55:25','2021-08-12 08:55:25'),(4,'user2','e0517945da7b4f147f435db57e99007b15ea723adf61fcc1ee8bd2deac43281f','cfed79657dd2c3c97325b5c16d01b7a78f17ba631ba248a0ec3bb8219aa1e7ec','user2@gmail.com','102','Android','1','2021-08-12 08:55:35','2021-08-12 08:55:35'),(5,'user3','b79158cab7da6df0e859d3d6fedd9ae70d7a3573790576d4217b4c9d3311573a','b16e3e21a4010f0e8e05f65970bab096b0463f16ec335164e681beefaeb54925','user3@gmail.com','102','Android','0','2021-08-12 08:56:05','2021-08-12 08:56:05'),(6,'user4','eab3acf1c81a193fef4c8c23e5c8b9251755946ae774ac799ea897623f9a8f47','cfeff6e7457addd14e1b10f68d8eb7fd7e683ff5cfaad5d0b8b15345ffea3d92','user4@gmail.com','102','Android','1','2021-08-12 08:56:20','2021-08-12 08:56:20'),(7,'user5','2e59cede1a34c0a7b88ed2d6b70c29a3a5f886977699aa8dfd4d7dcf63112075','2df6eba1ddf853668008d3f263e22e164c18b1a585b62196df1e9fd17659dddd','user5@gmail.com','102','Android','1','2021-08-12 08:56:27','2021-08-12 08:56:27'),(8,'user6','1054d33d750087f44d9836cde3e97e68af8f06100e68620d40a2c21b90ba781c','8a471e0851ef47574488528a0010e000e350cf316372a5a70e9ceb97ce0e2ec7','user6@gmail.com','102','Android','1','2021-08-12 08:56:29','2021-08-12 08:56:29');
